<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs"
    version="2.0">
    <!-- XSLT-Wurzelelement. Darin werden verschiedene Namensräume in Attributen angegeben.
    Anmerkung: Eine Transformation der Art unten ist genauso für TEI-Dokumente geeignet. 
    Man müsste dann nur im xsl:stylesheet-Tag folgendes Attribut für den TEI-Namensraum 
    ergänzen: xpath-default-namespace="http://www.tei-c.org/ns/1.0"
    Und natürlich die Schablonen für Element- und Attributnamen machen, die aus der TEI kommen! -->
    
    <xsl:template match="/">
        <!-- Wurzeltemplate (= die Schablone, die auf die "Wurzel" des Eingabedokuments passt -->
        <!-- Weil die Wurzel im XML-Baum ganz oben ist, beginnt die Transformation mit dieser 
        Schablone. Der XSLT-Prozessor geht den XML-Baum nach und nach durch und führt die 
        Transformation weiter: Immer, wenn in dem XSLT-Stylesheet Schablonen (= Templates)
        auftauchen, die passen, werden diese angewandt. Die Reihenfolge, wie die Schablonen 
        abgearbeitet werden, ergibt sich also daraus, wie die Struktur des Eingabe-XMLs ist und
        wann welche Schablone zu Elementen (und Attributen und Text) aus dem Eingabedokument passt. -->
        <html>
            <!-- Ab hier werden HTML-Elemente geschrieben, innerhalb der Schablone!
            Die werden Teil des Ergebnisdokuments. -->
            <head><!-- HTML-Kopfbereich (wird im Browser nicht angezeigt) -->
                <meta charset="UTF-8"></meta><!-- Angabe der HTML-Zeichencodierung -->
                <title>Gedicht</title><!-- Das wird als Titel der Seite im Browsertab angezeigt -->
            </head>
            <body><!-- HTML-Bodybereich -->
                <div><!-- Ein Abschnitt -->
                    <xsl:apply-templates/><!-- Hier wird gesagt: Weitere Schablonen berücksichtigen!
                    Das heißt: Der XSLT-Prozessor ist im Moment bei der Wurzel des Eingabedokuments.
                    (Wir sind im Wurzeltemplate). Wir haben ein paar HTML-Elemente geschrieben.
                    Jetzt geht der Prozessor von dem Wurzelelement im XML-Baum weiter runter und 
                    läuft alle Elemente durch. Wenn hier NICHT apply-templates stehen würde, 
                    würde aber nichts mehr passieren, weil wir dem Prozessor nicht erlaubt haben,
                    noch andere Schablonen zu berücksichtigen. SO wird ihm gesagt, dass 
                    für alle Descendants (also Kindelemente und Kindeskinder usw.) weitere Schablonen
                    kommen können. -->
                </div>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template match="titel">
        <!-- Ein zweites Template, das auf alle <titel>-Element aus dem Eingabedokument passt
        und auf diese angewendet wird, sobald sie an der Reihe sind. -->
        <h1><!-- Anstelle von <titel> im Eingabedokument wird hier für das Ausgabedokument
        eine HTML-Überschrift konstruiert. -->
            <xsl:apply-templates/><!-- Es wird wieder gesagt: Berücksichtige weitere Schablonen
            Falls das Titel-Element also noch Kind-Elemente haben sollte, könnte es dafür 
            andere Schablonen geben, die berücksichtigt werden. -->
        </h1>
    </xsl:template>
    
    <xsl:template match="lg"><!-- Weiteres Template, für Strophen-Elemente.
    Das Prinzip ist das gleiche wie beim Titel-Template. -->
        <p><!-- Daraus wird im Ergebnisdokument ein HTML-Absatz-Element. -->
            <xsl:apply-templates/><!-- Auch hier sollen weitere Schablonen berücksichtig werden. -->
        </p>
    </xsl:template>
    
    <xsl:template match="l"><!-- Weitere Schablone für Vers-Elemente. -->
        <xsl:apply-templates/><br/><!-- Hier steht zuerst: berücksichtige weitere Schablonen.
        Falls die Vers-Elemente noch Kindelemente hätten, könnte es auch dafür Schablonen geben.
        Das apply-templates ist hier aber auch wichtig, damit am Ende der Textinhalt der
        Elemente ausgegeben wird! -->
        <!-- <br/> ist ein HTML-Zeilenumbruch. Hier wird nun also kein öffnendes und schließendes
        Tag um jeden Vers gelegt, sondern nur am Ende ein Zeilenumbruch (= leeres Element) gemacht. -->
    </xsl:template>
    
    
    <!-- keine weiteren Templates, aber es gibt ein verstecktes Text-Template, welches
    am Ende des Durchlaufs durch den XML-Baum des Eingabedokuments alle Textknoten ausgibt! 
    Daher erscheint der Text des Gedichts nachher im Ergebnis, ohne dass man das explizit gesagt hat.
    Man hat also die Eingabe-Elemente zum Teil umbenannt (lg -> p), Elemente ergänzt (aus gedicht wurde
    eine ganze HTML-Struktur) und bestimmte Dinge weggelassen (die Attribute von <gedicht> z.B.)
    und so das Eingabe-XML-Gedicht in eine HTML-Datei umgewandelt. -->
    
    
    
</xsl:stylesheet>